///////////////////////////////////////////////////////////////////
// iCEnhancer 2.1 .FX file
// made by : iCE La GlacE
// contact : icelaglace@yahoo.fr
// Feel free to mod it like you want & distribute on your own settings
// As long as you mention everyone's names
// 
//Copyright : Boris Vorontsov/iCE La GlacE/gp65cj04/DKT70/Dpeasant3
//
//////////////////////////////////////////////////////////////////


//++++++++++++++++++++++++++
// DEPTH OF FIELD
//++++++++++++++++++++++++++

#define DEPTH_OF_FIELD

//-----------------------------
// 1 IS ADVANCED DEPTH OF FIELD (ADOF) //DEFAULT
// 2 IS NO PERFORMANCE LOSS DEPTH OF FIELD FROM iCENHANCER 1.25
//-----------------------------

//#define LQ_DOF
#define HQ_DOF


//-----------------------------
// AUTO-FOCUS DEPTH OF FIELD, BLURS DEPENDING OF WHERE YOU LOOK
//-----------------------------

//#define AUTOFOCUS


//-----------------------------
// HQ_DOF SETTINGS (ADOF)
//-----------------------------

#define DOF_NORMAL_QUALITY
//#define DOF_HIGH_QUALITY

//-----------------------------
// 0.4 is the default value & recommended.
// 0.8 is the max I recommend without making the image too horrible.
//-----------------------------

float BlurIntensity = 0.4;

//-----------------------------
// DOF_Taps can be reduced to 8 if you need perf on DEPTHOFFIELD 1 mode
// PixelSize is if your DOF is not visible enough for your liking
//-----------------------------

int DoF_TAPS = 60;
int PixelSizeMultiplier = 1;

//-----------------------------
// This is where the DOF is focusing
// It's (Y,X) values, means that if you want it to focus higher, do :
// (0.4, 0.5);
// You want it to focus more in the right, do :
// (0.5, 0.6); etc...
 //-----------------------------

float2 FocusPoint = float2(0.5, 0.5);


//++++++++++++++++++++++++++
// BLOOM & IMAGE SETTINGS
//++++++++++++++++++++++++++


//-----------------------------
// Main value of bloom
//-----------------------------
float BloomAmountMix = 1.85;

//-----------------------------
// Additional image bloom, created in post-processing, not icebloom.fx related
// Not that recommended but you can give it a try
//-----------------------------

float BloomAdditive = 0;

//-----------------------------
// Change the adaptation to brightness of the game.
// Less value, darker game.
// Don't touch this settings until you are sure it's the only solution!
//-----------------------------

float AdaptationValue = 0.55;

//-----------------------------
// TONEMAPPING :
//-----------------------------
// Converts the high dynamic range image HDR to a lower dynamic range image (LDR).
// Tone mapping is a technique used to approximate the appearance
// of high dynamic range images on a display with a more limited dynamic range.
// Helps to avoid pure whites & pure blacks.
//-----------------------------

#define FILMICCURVE
//#define FILMICGAMMA
//#define LOGARITHMIC
//#define REINHARD
//#define REINHARD_ICE21
//#define HELJ

float toneMapExposure = 1.2;

//-----------------------------
// Bleach Bypass
// http://en.wikipedia.org/wiki/Bleach_bypass
// Makes the white "whiter" and blacks darker
// Washed up effect
//-----------------------------

//#define BLEACH
float BP_factor = 0.25;

//-----------------------------
// Saturation
// Enable it & tweak like like you want.
// 1.33 = Default saturation for 2.1
// 0.25 = Default contrast for 2.1
//-----------------------------

#define GlobalSaturation
float Saturation = 0.63;
float AddContrast = 0.50;


//-----------------------------
// Vignetting 
// http://en.wikipedia.org/wiki/Vignetting
// Makes the border edges a little darker
//-----------------------------

float Vignetting = 0.2;

//-----------------------------
// Default motion blur is the alternative one : 
// Alternative : grainy, smooth motion blur
// Default : Less smooth but no grain
//-----------------------------

//#define NormalMB
#define AlternativeMB

//#define BLACKBARS

////////////////////////////////////////////////////////////////////////////
////// END OF TWEAKING VALUES //////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////


struct VS_OUTPUT_POST
{
	float4 vpos  : POSITION;
	float2 txcoord0 : TEXCOORD0;
};
struct VS_INPUT_POST
{
	float3 pos  : POSITION;
	float2 txcoord0 : TEXCOORD0;
};


float4	_c44 : register(c44);
float4	_c66 : register(c66);
float4	_c72 : register(c72);
float4	_c73 : register(c73);
float4	_c74 : register(c74);
float4	_c75 : register(c75);
float4	_c76 : register(c76);
float4	_c77 : register(c77);
float4	_c78 : register(c78);
float4	_c79 : register(c79);
float4	_c80 : register(c80);
float4	_c81 : register(c81);
float4	_c82 : register(c82);
float4	_c83 : register(c83);
float4	_c84 : register(c84);
float4	_c85 : register(c85);


texture2D texs0 : register(s0);
texture2D texs1 : register(s1);
texture2D texs2 : register(s2);
texture2D texs3 : register(s3);
texture2D texs4 : register(s4);
texture2D texs5 : register(s5);
texture2D texs6 : register(s6);
texture2D texs7 : register(s7);
texture2D texs13 : register(s13);//palette
texture2D texs15 : register(s15);
sampler2D s2=sampler_state { Texture=<texs2>; };
sampler2D s4=sampler_state { Texture=<texs4>; };
#ifdef NormalMB
sampler2D s5=sampler_state { Texture=<texs5>; };
#endif
sampler2D s6=sampler_state { Texture=<texs6>; };
sampler2D s7=sampler_state { Texture=<texs7>; };
sampler2D s15=sampler_state { Texture=<texs15>; };

sampler2D s0 = sampler_state
{
    Texture   = <texs0>;
	MinFilter = LINEAR;//
	MagFilter = LINEAR;//
	MipFilter = NONE;//NONE;//LINEAR;
	AddressU  = Clamp;
	AddressV  = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

sampler2D s1 = sampler_state
{
    Texture   = <texs1>;
	MinFilter = LINEAR;//
	MagFilter = LINEAR;//
	MipFilter = NONE;//NONE;//LINEAR;
	AddressU  = Clamp;
	AddressV  = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

sampler2D s3 = sampler_state
{
    Texture   = <texs3>;
	MinFilter = LINEAR;//
	MagFilter = LINEAR;//
	MipFilter = NONE;//NONE;//LINEAR;
	AddressU  = Clamp;
	AddressV  = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};


#ifdef AlternativeMB
sampler2D s5 = sampler_state //fixed
{
Texture   = <texs5>;
MinFilter = LINEAR;
MagFilter = LINEAR;
MipFilter = NONE;
AddressU  = Wrap;
AddressV  = Wrap;
SRGBTexture=FALSE;
MaxMipLevel=0;
MipMapLodBias=0;
};
#endif

sampler2D s13 = sampler_state
{
Texture   = <texs13>;
MinFilter = LINEAR;
MagFilter = LINEAR;
MipFilter = NONE;
AddressU  = Clamp;
AddressV  = Clamp;
SRGBTexture=FALSE;
MaxMipLevel=0;
MipMapLodBias=0;
};

float4 PS_C215BE6E(VS_OUTPUT_POST IN) : COLOR
{
	float4 _oC0=0.0; //output
	float4 _c0=float4(0, 0.212500006, 0.715399981, 0.0720999986);
	float4 _c1=float4(0.25, 1, 256, 0);
	float4 _c2=float4(0, 2, 4, 8);
	float4 _c3=float4(58.1640015, 47.1300011, 0, 0);
	float4 _c4=float4(-0.5, -1.5, 1.5, 0.5);
	float4 _c5=float4(2, -1, 0.125, 0);
	float4 _c6=float4(256, 2, 4, 8);
	float4 _c7=float4(1.0, 0.1, 0.8, 1.0);
	float4 _c8=float4(0.0, 0.1, 0.8, 0.333);
	float4 _c9=float4(0.06, 0.1, 0.8, 0.1);
	float4 _c10=float4(0.01, 1.4, 0.0, 0.32);
	float4 _c11=float4(0.333333, 1.0, 0.0, 0.0);
	float4 _c12=float4(0.27, 0.67, 0.06, 0.0);
	float4 _c13=float4(0.0, 0.0, 0.0, 0.00001);
	float4 _c150=float4(0.55, 0.9, 0.85, 0.9);
	float4 _c195=float4(0.0, 0.0, 0.0, 0.07);//0.7
	float4 r0;
	float4 r1;
	float4 r2;
	float4 r3;
	float4 r4;
	float4 r5;
	float4 r6;
	float4 r7;
	float4 r8;
	float4 r9;
	float4 r10;
	float4 r11;
float4 _v0=0.0;
_v0.xy=IN.txcoord0.xy;


r1=tex2D(s2, _v0.xy); //HDRSampler
r2=tex2D(s3, _v0.xy); //BloomSampler



//*************************
#ifdef HQ_DOF
	float2	center;
	float	depth;
	float	focus;
	
	r0=tex2D(s1, _v0.xy); //GBufferTextureSampler3
	r0.y=-_c77.x + _c77.y; //-dofProj.x + dofProj.y
	r0.y=1.0/r0.y;
	r0.z=r0.y * _c77.y; //dofProj.y
	r0.z=r0.z * -_c77.x; //dofProj.x
	r0.x=_c77.y * -r0.y + r0.x;
	r0.x=1.0/r0.x;
	r0.y=r0.z * r0.x;

	r0.w=abs(_c79.w);
	r3=_c4; //-0.5, -1.5, 1.5, 0.5

#ifndef AUTOFOCUS
	float4	vDofParams = float4(-4, 1, 5000.0, 1);
#else
	float4	vDofParams = float4(-5000, 1, 30000.0, 1);
#endif

	depth=r0.z * r0.x - _c78.w; //dofDist.w
	depth+=_c78.y * -r3.w; //dofDist.y
	depth+=148;//offset
	center.x=_v0.x-0.5;
	center.y=0.5-_v0.y;
#endif
	#ifdef DEPTH_OF_FIELD
	r4=tex2D(s1, FocusPoint); //GBufferTextureSampler3
	r4.y=-_c77.x + _c77.y; //-dofProj.x + dofProj.y
	r4.y=1/r4.y;
	r4.z=r4.y * _c77.y; //dofProj.y
	r4.z=r4.z * -_c77.x; //dofProj.x
	r4.x=_c77.y * -r4.y + r4.x;
	r4.x=1/r4.x;
	r4.y=r4.z * r4.x;	
	#ifdef AUTOFOCUS
	float cdepth;

	cdepth=r4.z * r4.x - _c78.w; //dofDist.w
	cdepth+=_c78.y * -r3.w; //dofDist.y
	cdepth+=150;//offset

	
	r4.w = tex2D(s0, FocusPoint).w;
	if(r4.w > 0)
	{
		vDofParams.z = cdepth*10.0;
		vDofParams.y = cdepth;
	}
	#endif
#ifdef HQ_DOF

	depth = max(depth, 0);

	float	dist;

	if(depth < vDofParams.y)
	    dist = (depth - vDofParams.y)/(vDofParams.y - vDofParams.x);
	else
	{
	    dist = (depth - vDofParams.y)/(vDofParams.z - vDofParams.y);
	    dist = clamp(dist, 0, vDofParams.w);
	}

    	dist = dist * 0.5 + 0.5;
#endif
#ifdef DOF_NORMAL_QUALITY

	static float3 poisson[24]=
	{
		float3(1.0, 0.0, 1.0000 ), //0 degrees
		float3(0.0, -1.0, 1.0000 ),
		float3(-1.0, 0.0, 1.0000 ),
		float3(0.0, 1.0, 1.0000 ),

		float3(0.7071, 0.7071, 1.0000 ), //45 degrees
		float3(0.7071, 0.7071, 1.0000 ),
		float3(-0.7071, -0.7071, 1.0000 ),
		float3(-0.7071, 0.7071, 1.0000 ),

		float3(0.9659, 0.2588, 1.0000 ), //15 degrees
		float3(0.2588, -0.9659, 1.0000 ),
		float3(-0.9659, -0.2588, 1.0000 ),
		float3(-0.2588, 0.9659, 1.0000 ),

		float3(0.8660, 0.5000, 1.0000 ), //60 degrees
		float3(0.5000, -0.8660, 1.0000 ),
		float3(-0.8660, -0.5000, 1.0000 ),
		float3(-0.5000, 0.8660, 1.0000 ),

		float3(0.5000, 0.8660, 1.0000 ), //30 degrees
		float3(0.8660, -0.5000, 1.0000 ),
		float3(-0.5000, -0.8660, 1.0000 ),
		float3(-0.8660, 0.5000, 1.0000 ),

		float3(0.2588, 0.9659, 1.0000 ), //75 degrees
		float3(0.9659, -0.2588, 1.0000 ),
		float3(-0.2588, -0.9659, 1.0000 ),
		float3(-0.9659, 0.2588, 1.0000 ),
	};
#endif


#ifdef DOF_HIGH_QUALITY

static float3 poisson[60] =
       {
           float3( 0.2165, 0.1250, 1.0000 ),
           float3( 0.0000, 0.2500, 1.0000 ),
           float3( -0.2165, 0.1250, 1.0000 ),
           float3( -0.2165, -0.1250, 1.0000 ),
           float3( -0.0000, -0.2500, 1.0000 ),
           float3( 0.2165, -0.1250, 1.0000 ),
           float3( 0.4330, 0.2500, 1.0000 ),
           float3( 0.0000, 0.5000, 1.0000 ),
           float3( -0.4330, 0.2500, 1.0000 ),
           float3( -0.4330, -0.2500, 1.0000 ),
           float3( -0.0000, -0.5000, 1.0000 ),
           float3( 0.4330, -0.2500, 1.0000 ),
           float3( 0.6495, 0.3750, 1.0000 ),
           float3( 0.0000, 0.7500, 1.0000 ),
           float3( -0.6495, 0.3750, 1.0000 ),
           float3( -0.6495, -0.3750, 1.0000 ),
           float3( -0.0000, -0.7500, 1.0000 ),
           float3( 0.6495, -0.3750, 1.0000 ),
           float3( 0.8660, 0.5000, 1.0000 ),
           float3( 0.0000, 1.0000, 1.0000 ),
           float3( -0.8660, 0.5000, 1.0000 ),
           float3( -0.8660, -0.5000, 1.0000 ),
           float3( -0.0000, -1.0000, 1.0000 ),
           float3( 0.8660, -0.5000, 1.0000 ),
           float3( 0.2163, 0.3754, 0.8670 ),
           float3( -0.2170, 0.3750, 0.8670 ),
           float3( -0.4333, -0.0004, 0.8670 ),
           float3( -0.2163, -0.3754, 0.8670 ),
           float3( 0.2170, -0.3750, 0.8670 ),
           float3( 0.4333, 0.0004, 0.8670 ),
           float3( 0.4328, 0.5004, 0.8847 ),
           float3( -0.2170, 0.6250, 0.8847 ),
           float3( -0.6498, 0.1246, 0.8847 ),
           float3( -0.4328, -0.5004, 0.8847 ),
           float3( 0.2170, -0.6250, 0.8847 ),
           float3( 0.6498, -0.1246, 0.8847 ),
           float3( 0.6493, 0.6254, 0.9065 ),
           float3( -0.2170, 0.8750, 0.9065 ),
           float3( -0.8663, 0.2496, 0.9065 ),
           float3( -0.6493, -0.6254, 0.9065 ),
           float3( 0.2170, -0.8750, 0.9065 ),
           float3( 0.8663, -0.2496, 0.9065 ),
           float3( 0.2160, 0.6259, 0.8851 ),
           float3( -0.4340, 0.5000, 0.8851 ),
           float3( -0.6500, -0.1259, 0.8851 ),
           float3( -0.2160, -0.6259, 0.8851 ),
           float3( 0.4340, -0.5000, 0.8851 ),
           float3( 0.6500, 0.1259, 0.8851 ),
           float3( 0.4325, 0.7509, 0.8670 ),
           float3( -0.4340, 0.7500, 0.8670 ),
           float3( -0.8665, -0.0009, 0.8670 ),
           float3( -0.4325, -0.7509, 0.8670 ),
           float3( 0.4340, -0.7500, 0.8670 ),
           float3( 0.8665, 0.0009, 0.8670 ),
           float3( 0.2158, 0.8763, 0.9070 ),
           float3( -0.6510, 0.6250, 0.9070 ),
           float3( -0.8668, -0.2513, 0.9070 ),
           float3( -0.2158, -0.8763, 0.9070 ),
           float3( 0.6510, -0.6250, 0.9070 ),
           float3( 0.8668, 0.2513, 0.9070 )
       };

#endif
	float2	pixelSizeHigh;
	float2	pixelSizeLow;


	pixelSizeHigh.x = 1.000 / _c44.x;
	pixelSizeHigh.y = 1.000 / _c44.y;

	//pixelSizeHigh.x = 2.0 / _c44.x;
	//pixelSizeHigh.y = 2.0 / _c44.y;

	pixelSizeHigh.xy *= PixelSizeMultiplier;

	pixelSizeLow.xy = pixelSizeHigh.xy;

	float2	vMaxCoC = float2(5.0, 10.0);

	float	radiusScale = BlurIntensity;
	
	float	discRadius;
	float	discRadiusLow;
	float	centerDepth;
	float4	tdepth;

	float4  tapHigh;
	float4  tapLow;

	centerDepth = dist;
	
	discRadius = abs(centerDepth * vMaxCoC.y - vMaxCoC.x);
	discRadiusLow = discRadius * radiusScale;
	
	r1 = 0.0;

	for(int t = 0; t < DoF_TAPS; t++)
	{
	    float2  coordLow = _v0.xy + (pixelSizeLow.xy * poisson[t].xy * discRadiusLow);
	    float2  coordHigh = _v0.xy + (pixelSizeHigh.xy * poisson[t].xy * discRadius);

	    tapLow = tex2D(s2, coordLow.xy) * poisson[t].z;
	    tapHigh = tex2D(s2, coordHigh.xy) * poisson[t].z;

	    tdepth = tex2D(s1, coordHigh.xy); //GBufferTextureSampler3
	    tdepth.y = -_c77.x + _c77.y; //-dofProj.x + dofProj.y
	    tdepth.y = 1.0 / tdepth.y;
	    tdepth.z = tdepth.y * _c77.y; //dofProj.y
	    tdepth.z = tdepth.z * -_c77.x; //dofProj.x
	    tdepth.x = _c77.y * -tdepth.y + tdepth.x;
	    tdepth.x = 1.0 / tdepth.x;

	    tdepth.w = tdepth.z * tdepth.x - _c78.w; //dofDist.w
	    tdepth.w += _c78.y * -r3.w; //dofDist.y
	    tdepth.w += 150;//offset

	    tdepth.w = max(tdepth.w, 0); //fix zoom bug

	    if(tdepth.w < vDofParams.y)
	        tapHigh.w = (tdepth.w - vDofParams.y)/(vDofParams.y - vDofParams.x);
	    else
	    {
	        tapHigh.w = (tdepth.w - vDofParams.y)/(vDofParams.z - vDofParams.y);
	        tapHigh.w = clamp(tapHigh.w, 0, vDofParams.w);
	    }

    	    tapHigh.w = tapHigh.w * 0.5 + 0.5;

	    tapLow.w = tapHigh.w;

	    float  tapBlur = abs(tapHigh.w * 2.0 - 1.0);
	    float4  tap = lerp(tapHigh, tapLow, tapBlur);

	    if(tap.w >= centerDepth)	tap.w = 1.0;
	    else	tap.w = abs(tap.w * 2.0 - 1.0);

	    r1.xyz += tap.xyz * tap.w;
	    r1.w += tap.w;


	}
	
	r1.xyz /= r1.w;	

#endif
#ifdef HQ_DOF
	r1.w=dot(r1.xyz, r1.xyz); //dp3
	r1.w=1.0/r1.w;

	//if (-r1.w<0.0) r3 = r1;
	//else r3 = _c0.x;

	r3 = lerp(_c0.x, r1, saturate(r1.w * 10000));

	r4 = r3;
	r5 = r3;
	r6 = r3;
	r7 = r3;
#endif
///////////////////////////////////////
///////////////////////////////////////
#ifdef LQ_DOF

float	MaxBlur = 1;
float	MinBlur = 0.25;

float2	center;
float	distance;
float	focus;
float	farblur;
float	dof;
float	centerdist;	
float	deltadist;

float	autofocus;

float	sampleradius = 0.01;
float	errorradius = 2;
float	blurradius = 20.0;

r3=_c4; //-0.5, -1.5, 1.5, 0.5

static float2 d_offset[60]=
{
float2( 0.2165, 0.1250 ),
float2( 0.0000, 0.2500 ),
float2( -0.2165, 0.1250 ),
float2( -0.1250, 1.0000 ),
float2( -0.0000, -0.2500 ),
float2( 0.1250, 1.0000 ),
float2( 0.4330, 1.0000 ),
float2( 0.0000, 0.5000 ),
float2( -0.4330, 1.0000 ),
float2( 0.4330, -1.0000 ),
float2( -0.5000, 1.0000 ),
float2( 0.4330, -0.2500 ),
float2( 0.6495, 0.3750 ),
float2( 0.0000, 0.7500 ),
float2( -0.6495, 0.3750 ),
float2( 0.6495, -0.3750 ),
float2( -0.7500, 1.0000 ),
float2( -0.3750, 1.0000 ),
float2( 0.8660, 0.5000 ),
float2( 1.0000, 1.0000 ),
float2( -0.8660, -0.5000 ),
float2( -0.8660, 0.5000 ),
float2( -1.0000, -1.0000 ),
float2( 0.8660, 1.0000 ),
float2( 0.2163, 0.3754 ),
float2( -0.2170, 0.8670 ),
float2( -0.4333, -0.0004 ),
float2( 0.2163, -0.8670 ),
float2( 0.2170, -0.3750 ),
float2( 0.4333, 0.0004 ),
float2( 0.4328, 0.5004 ),
float2( -0.2170, 0.6250 ),
float2( -0.6498, 0.1246 ),
float2( -0.5004, 0.8847 ),
float2( 0.2170, 0.8847 ),
float2( -0.1246, -0.8847 ),
float2( 0.6254, -0.9065 ),
float2( 0.8750, 0.9065 ),
float2( -0.8663, 0.9065 ),
float2( -0.6493, -0.6254 ),
float2( 0.2170, 0.9065 ),
float2( 0.8663, -0.9065 ),
float2( 0.6259, 0.8851 ),
float2( -0.4340, 0.8851 ),
float2( -0.6500, -0.1259 ),
float2( -0.6259, -0.8851 ),
float2( -0.5000, -0.8851 ),
float2( 0.6500, 0.1259 ),
float2( 0.7509, 0.1259 ),
float2( -0.4340, 0.8670 ),
float2( -0.8665, -0.0009 ),
float2( -0.7509, 0.8670 ),
float2( 0.4340, -0.7500 ),
float2( 0.0009, 0.8670 ),
float2( 0.2158, 0.9070 ),
float2( -0.6510, 0.9070 ),
float2( -0.2513, -0.9070 ),
float2( -0.8763, -0.9070 ),
float2( 0.6510, -0.6250 ),
float2( 0.2513, 0.9070 )
};


float distsum = 0;

for(int i=0; i < 25; i++)
{
   r0 = tex2D(s1, 0.5 + d_offset[i] * sampleradius);
   r0.y=-_c77.x + _c77.y; //-dofProj.x + dofProj.y
   r0.y=1.0/r0.y;
   r0.z=r0.y * _c77.y; //dofProj.y
   r0.z=r0.z * -_c77.x; //dofProj.x
   r0.x=_c77.y * -r0.y + r0.x;
   r0.x=1.0/r0.x;

   distance=r0.z * r0.x - _c78.w; //dofDist.w
   distance+=_c78.y * -r3.w; //dofDist.y
   distance+=140;//offset

   distsum += distance;
}

centerdist = distance;

distsum *= 0.04;
deltadist = abs(distsum - centerdist);


r0=tex2D(s1, _v0.xy); //GBufferTextureSampler3
r0.y=-_c77.x + _c77.y; //-dofProj.x + dofProj.y
r0.y=1.0/r0.y;
r0.z=r0.y * _c77.y; //dofProj.y
r0.z=r0.z * -_c77.x; //dofProj.x
r0.x=_c77.y * -r0.y + r0.x;
r0.x=1.0/r0.x;
r0.y=r0.z * r0.x;

r0.w=abs(_c79.w);


distance = r0.z * r0.x - _c78.w; //dofDist.w
distance += _c78.y * -r3.w; //dofDist.y
distance += 140;//offset

center.x = _v0.x-0.5;
center.y = 0.5-_v0.y;
focus = length(center.xy)*1.41421;
focus = pow(focus,2);
focus *= MaxBlur;

farblur = saturate((distance - 25)*0.0025) * 0.1;

if(distance < 25)
{
   farblur = 1;
   dof = MinBlur;
}
else dof = MaxBlur;

blurradius = 1 / blurradius;

if(deltadist < errorradius)
{
   dof = MaxBlur;
   autofocus = abs(distance - centerdist);
   autofocus = saturate(autofocus * blurradius);
}
else   autofocus = farblur;

if(centerdist > 50) autofocus = farblur;


//TEMP decrease bluriness for edge smoothing
float2 off_c76 = _c76.xy * min(dof + focus, MaxBlur); 


r1=tex2D(s2, _v0.xy); //HDRSampler
r2=tex2D(s3, _v0.xy); //BloomSampler

float2 tempuvx=0.0;


//r3=float4(-0.5, -1.5, 1.5, 0.5);
//-0.5, -1.5
//-0.5, 1.5
// 1.5, 0.5
//-1.5, 0.5


float4 r12=r3;
r4.xy=off_c76.xy * r3.xy + _v0.xy; //TexelSize.xy
r4=tex2D(s2, r4.xy); //HDRSampler
r4=0.5*(r4 + tex2D(s2, _v0.xy + 1*off_c76.xy * reflect(r12.xy, normalize(float3(sin(0.7853981634*2), cos

(0.7853981634*2), 0.0)))) );

r5.xy=off_c76.xy * r3.zx + _v0.xy; //TexelSize.xy
r5=tex2D(s2, r5.xy); //HDRSampler
r5=0.5*(r5 + tex2D(s2, _v0.xy + 1*off_c76.xy * reflect(r12.zx, normalize(float3(sin(0.7853981634*2), cos

(0.7853981634*2), 0.0)))) );

r3.xz=off_c76.xy * r3.wz + _v0.xy; //TexelSize.xy
r6=tex2D(s2, r3.xz); //HDRSampler
r6=0.5*(r6 + tex2D(s2, _v0.xy + 1*off_c76.xy * reflect(r12.wz, normalize(float3(sin(0.7853981634*2), cos

(0.7853981634*2), 0.0)))) );

//r3.xy=off_c76.xy * r3.yw + _v0;	//TexelSize.xy
r3.xy=_c76.xy * r3.yw*(0.2+1.0) + _v0;	
r7=tex2D(s2, r3.xy); //HDRSampler
r7=0.5*(r7 + tex2D(s2, _v0.xy + 1*off_c76.xy * reflect(r12.yw, normalize(float3(sin(0.7853981634*2), cos

(0.7853981634*2), 0.0)))) );
	r1.w=dot(r4.xyz, r4.xyz);
	r1.w=1.0/r1.w;
	if (-r1.w<0.0)
	{
		r3.xyz=r4.xyz;
	} else r3.xyz=_c0.x;

	r1.w=dot(r5.xyz, r5.xyz); //dp3
	r1.w=1.0/r1.w;
	if (-r1.w<0.0)
	{
		r4.xyz=r5.xyz;
	} else r4.xyz=_c0.x;

	r1.w=dot(r6.xyz, r6.xyz); //dp3
	r1.w=1.0/r1.w;
	if (-r1.w<0.0)
	{
		r5.xyz=r6.xyz;
	} else r5.xyz=_c0.x;

	r1.w=dot(r7.xyz, r7.xyz); //dp3
	r1.w=1.0/r1.w;
	if (-r1.w<0.0)
	{
		r6.xyz=r7.xyz;
	} else r6.xyz=_c0.x;

	r1.w=dot(r1.xyz, r1.xyz); //dp3
	r1.w=1.0/r1.w;
	if (-r1.w<0.0)
	{
		r7.xyz=r1.xyz;
	} else r7.xyz=_c0.x;

#endif

///////////////////////////////////////
///////////////////////////////////////
	r0.x=r0.z * r0.x - _c78.w; //dofDist.w
	r0.x=_c78.y * -r3.w + r0.x; //dofDist.y
	r1.w=max(r0.x, _c0.x); //0.0
	r0.x=1.0/_c78.z; //dofDist.z
	r0.x=r1.w * r0.x;
	r1.w=lerp(_c79.y, _c79.z, r0.x);//dofBlur
	r0.x=min(_c79.z, r1.w); //dofBlur.z

	r0.z=dot(r7.xyz, _c0.yzw); //0.212500006, 0.715399981, 0.0720999986
	r8.x=dot(r3.xyz, _c0.yzw); //0.212500006, 0.715399981, 0.0720999986
	r8.y=dot(r4.xyz, _c0.yzw); //0.212500006, 0.715399981, 0.0720999986
	r8.z=dot(r5.xyz, _c0.yzw); //0.212500006, 0.715399981, 0.0720999986
	r8.w=dot(r6.xyz, _c0.yzw); //0.212500006, 0.715399981, 0.0720999986
	r1.w=dot(r8, _c1.xxxx); //0.25

	r8=r8 - r1.w;
	r2.w=dot(r8, r8);
	r0.z=r0.z - r1.w;
	r0.z=r0.z * r0.z - r2.w;
	r0.x=r0.x*r0.x;
	if (r0.z<0.0)
	{
		r0.x=r0.x;
	} else r0.x=_c1.y; //1.0


	r8=tex2D(s0, _v0.xy); //GBufferTextureSampler2


	r8.yz=_c1.yz; // 1.0, 256.0
	r9=r8.w * -r8.z + _c2; //0, 2, 4, 8
	if (r9.w<0.0) //r9<0.0
	{
		r9=_c1.w; //0.0
	} else r9=_c1.y; //1.0


	//r10=r8.w + tempc6;//c6.yzwx; //256, 2, 4, 8
	r10=r8.w * -_c6.x + _c6.yzwx; //256, 2, 4, 8


	if (r10.x<0.0)
	{
		r10.x=-_c1.w; //0.0
	} else r10.x=-_c1.y; //1.0

	if (r10.y<0.0)
	{
		r10.y=-_c1.w; //0.0
	} else r10.y=-_c1.y; //1.0

	if (r10.z<0.0)
	{
		r10.z=-_c1.w; //0.0
	} else r10.z=-_c1.y; //1.0

	if (r10.w<0.0)
	{
		r10.w=-_c1.w; //0.0
	} else r10.w=-_c1.y; //1.0


	r9=r9 + r10;
	r9=r9 * _c4.x; //-0.5


	r0.z=dot(r9, _c1.yyyy); //1.0
	r0.z=r0.z + _c4.w; //0.5
	r0.z=1.0/r0.z;
	r8.xzw=r3.xyz * r9.x;


	r7.xyz=r7 * _c4.w + r8.xzw; //0.5
	r7.xyz=r4 * r9.y + r7;
	r7.xyz=r5 * r9.z + r7;
	r7.xyz=r6 * r9.w + r7;
	r7.xyz=r0.z * r7;
	r0.z=-r0.x + _c1.y; //1.0
	r1.w=r0.x * _c1.x; //0.25


	r3.xyz=r3 * r1.w;
	r3.xyz=r7 * r0.z + r3;
	r3.xyz=r4 * r1.w + r3;
	r3.xyz=r5 * r1.w + r3;
	r3.xyz=r6 * r1.w + r3;


	//r4.xyz=_v0.yxy * _c5.x + _c5.y; //2, -1
	r4.x=_v0.y * _c5.x + _c5.y;
	r4.y=_v0.x * _c5.x + _c5.y;
	r4.z=_v0.y * _c5.x + _c5.y;


r0.z=r4.y * _c77.z; //dofProj.z
r0.z=r0.y * r0.z;
r1.w=-r4.x * _c77.w; //dofProj.w
r1.w=r0.y * r1.w;
r5.xyz=r1.w * _c73; //motionBlurMatrix.2
r5.xyz=r0.z * _c72 + r5; //motionBlurMatrix.1
r5.xyz=-r0.y * _c74 + r5; //motionBlurMatrix.3
r5.xyz=r5 + _c75; //motionBlurMatrix.4

r0.y=-r5.z * _c77.z; //dofProj.z
r0.y=1/r0.y;
r6.x=r5.x * r0.y;
r0.y=r5.z * _c77.w; //dofProj.w
r0.y=1/r0.y;
r6.y=r5.y * r0.y;
//r0.yz=-r4 + r6.xxyw;
r0.yz=-r4.yz + r6.xy;

//r0.yz=r0 * _c80.x; //gDirectionalMotionBlurLength.x
r0.y=r0.y * _c80.x;
r0.z=r0.z * _c80.x;
r4.xy=r0.yz * _c5.z; //0.125
r5=tex2D(s6, _v0.xy); //StencilCopySampler
r1.w=r5.x - _c85.x; //PLAYER_MASK.x
r4.zw=r3.xy * _c2.w; //8.0
r4.zw=_v0.xy * _c3.xy + r4.zw; //58.1640015, 47.1300011
r5=tex2D(s5, r4.zw); //JitterSampler
//r2.w=r5.x - 0.5; //-0.5
r4.zw=r4.xy * (r5.x - 4) + _v0.xy; //0.082 fixed
r5.xyz=r3.xyz;
r2.w=_c1.y; //1.0
r3.w=_c1.y; //1.0

for (int iii=0; iii<5; iii++)
{
r6.x=r4.x * r3.w + r4.z;
r6.y=r4.y * r3.w + r4.w;
 r7=tex2D(s6, r6.xy);
 r5.w=r7.x - _c85.x;
 if (r5.w<-0.3)
 {
 	r5.w=_c1.y; //1.0
 } else r5.w=_c1.w; //0.0
 r6=tex2D(s2, r6.xy);
 r5.xyz=r6.xyz * r5.w + r5.xyz;
 r2.w=r2.w + r5.w;
 r3.w=r3.w + _c1.y; //1.0
}



	r2.w=1.0/r2.w;

	//r0.yz=r0 * _c44.xxyw; //globalScreenSize
	r0.y=r0.y * _c44.x; //globalScreenSize
	r0.z=r0.z * _c44.y; //globalScreenSize

	r0.y=dot(r0.yz, r0.yz)+_c0.x;//dp2

	//r0.y=sqrt(r0.y);
	//r0.y=1.0/r0.y;
	r0.y=pow(r0.y, _c4.w); //0.5

	r0.y=r0.y * _c4.w; //0.5
	r0.x=r0.x + _c1.y; //1.0
	r0.x=1.0/r0.x;
	//r0.y is wrong
	r0.x=saturate(r0.y * r0.x);
	r4.xyz=r5 * r2.w - r3;
	r0.xyz=r0.x * r4 + r3;

	//_oC0.xyz=0.5*r0.xyz;

	if (-r1.w<0.0) r0.xyz=r3.xyz;
	if (-r0.w<0.0) r0.xyz=r1.xyz;

r11=r0;



	r1=tex2D(s4, _c0.x); //AdapLumSampler , 0.0
	r0.w=1.0/r1.x;
	r0.w=r0.w * _c81.y; //ToneMapParams.y
	r1.x=1.0/r0.w;
	r1.x=r1.x * _c81.x; //ToneMapParams.x
	r1.xyz=r2 * _c66.x - r1.x; //Exposure.x
	r2.xyz=max(r1, _c0.x); //0.0
	r1.xyz=r2 * _c81.z; //ToneMapParams.z
	r1.xyz=r1 * _c1.x; //0.25
	r0.xyz=r0 * _c66.x + r1; //Exposure.x
	r1.xyz=r0.w * r0;
	r1.x=dot(r1.xyz, _c0.yzw); //0.2125, 0.7154, 0.0721
	r0.xyz=r0 * r0.w - r1.x;
	r0.xyz=_c82.x * r0 + r1.x; //deSatContrastGamma.x
	r0.w=r1.x * _c84.w; //ColorShift.w
	r1.yzw=r0.w * _c84.xxyz; //ColorShift


	//darken as DarkeningAmount, but keeps colors
	r2.x=saturate(r0.w);
	r0.xyz=r0.xyz - _c84.xyz * r0.w; //ColorShift
	r0.xyz=r2.x * r0.xyz + r1.yzww;

	//coloring (green, brown, ...)
	r0.xyz=2.0 * r0.xyz * _c83.xyz; //ColorCorrect

	//keeps colors, changes luma
	r1.x=saturate(r1.x);
	r0.w=_c82.z - r8.y; //deSatContrastGamma.z
	r2.x=pow(r1.x, r0.w);

	_oC0.xyz=r0.xyz * r2.x; //orig
	_oC0.w=_c1.y; //1.0

r5=tex2D(s4, _c0.x);//adaptation luminance
r0=tex2D(s2, _v0.xy);

#ifdef LQ_DOF
r11.xyz = lerp(r0.xyz, r11.xyz, autofocus);
#endif

r0=r11;



r5.w=r5.x;
r5.w=AdaptationValue/r5.w;
r0.xyz=r0 * r5.w;
r3.xy=_c10.xwxw;
r3.xy=r3.xy * r5.w;

r7=tex2D(s3, _v0.xy);
//0.15 is bloom
r0=r7 * BloomAdditive + r0; //0.05 //TEMP DISABLED
r10=dot(r0.xyz, _c12.xyz);
r9.x=r10.x * 1.50;//c199.x;
r10.x=1.0/r10.x;
r10=r10 * r9.x;
r0=r0 * r10.x;
r0=r0 * _c7.y; 

r1=r0 * _c7.z;
r1=r1 + _c7.w;
r1.xyz=1.0/r1.xyz;
r0=r0 * r1;

//pallete texture (0.082 version feature)
#ifdef E_CC_PALETTE
r0.rgb=saturate(r0.rgb);
float3 brightness=0.001;//tex2D(s4, _c0.x);//adaptation luminance
//	brightness=brightness/(brightness+1.0);
float3 palette;
float4 uvsrc=0.0;
uvsrc.y=brightness.r;
uvsrc.x=r0.r;
palette.r=tex2Dlod(s13, uvsrc).r;
uvsrc.x=r0.g;
uvsrc.y=brightness.g;
palette.g=tex2Dlod(s13, uvsrc).g;
uvsrc.x=r0.b;
uvsrc.y=brightness.b;
palette.b=tex2Dlod(s13, uvsrc).b;
r0.rgb=palette.rgb;
#endif //E_CC_PALETTE


#ifdef GlobalSaturation
//float lumasat=dot(r0.xyz,_c12.xyz);
float gris=dot(r0.xyz, 0.333);
float3 SaturatedColor=pow(r0.xyz, Saturation);
float Niveaudegris=dot(SaturatedColor.xyz, 0.333);
float3 Resultat=SaturatedColor.xyz*gris/(Niveaudegris+0.0001);

#ifdef HQ_DOF
float4 Mix=lerp(1, 0.75, saturate(pow(depth/1000.0, 1)));
#endif
#ifdef LQ_DOF
float4 Mix=lerp(1, 0.75, saturate(pow(distance/1000.0, 1)));
#endif

r0.xyz = pow(Resultat,Mix);
#endif

//#define CROSSPROCESS
#ifdef CROSSPROCESS
float Weight;
float fRatio = 0.5;
float moodR = 0.33;
float moodG = 0.35;
float moodB = 0.4;
float4 colInput = r0;
float4 colMood = 1.0f;
colMood.r = moodR;
colMood.g = moodG;
colMood.b = moodB;
float fLum = ( colInput.r + colInput.g + colInput.b ) / 3;
colMood = lerp(0, colMood, saturate(fLum * 2.0));
colMood = lerp(colMood, 1, saturate(fLum - 0.5) * 2.0);
float4 colOutput = lerp(colInput, colMood, saturate(fLum * fRatio));
r0.rgb=max(0, colOutput);
r0.a=1.0;
#endif

#ifdef BLEACH
float	luma = dot(r0.xyz, _c12.xyz);
float3	blend = luma.xxx;
float	L = min(1, max(0, 10*(luma - 0.45)));
float3 result1 = 2.0 * r0.xyz * blend;
float3 result2 = 1.0 - 2.0*(1.0 - blend)*(1.0 - r0.xyz);
float3 newColor = lerp(result1.xyz, result2.xyz, L);
float3 mixRGB = BP_factor * newColor.xyz;
mixRGB += ((1.0f - BP_factor) * r0.xyz);
r0.xyz = mixRGB;
#endif

#ifdef FILMICCURVE
float A = 0.15; //= Shoulder Strength 
float B = 0.50; //= Linear Strength 
float C = 0.10; //= Linear Angle 
float D = 0.20; //= Toe Strength
float E = 0.02; //= Toe Numerator
float F = 0.30; //= Toe Denominator 
float W = 11.2; //= Weight
float4 curr = ((r0*(A*r0+C*B)+D*E)/(r0*(A*r0+B)+D*F))-E/F;
float4 whiteScale = ((W*(A*W+C*B)+D*E)/(W*(A*W+B)+D*F))-E/F;
r0 = curr*whiteScale;
r0 = r0 * 5.5;
#ifdef FILMICGAMMA
r0 = pow(r0,1/2.2);
#endif

#endif

#ifdef REINHARD_ICE21
float pixelLumi = dot(r0.xyz, _c12.xyz);
float toneMapCalc = pixelLumi / (pixelLumi + 1);
r0 =  toneMapCalc * pow(r0 / pixelLumi, Saturation);
r0 = r0 * toneMapExposure;
#endif

#ifdef REINHARD
r0 = r0 * toneMapExposure;
float pixelLumi = dot(r0.xyz, _c12.xyz);
float toneMapCalc = pixelLumi / (pixelLumi + 1);
r0 =  toneMapCalc * pow(r0 / pixelLumi, Saturation);
#endif

#ifdef HELJ
r0 = r0 * toneMapExposure;
r0 = max(0, r0 - 0.004);
r0 = (r0 * (6.2 * r0 + 0.5)) / (r0 * (6.2 * r0 + 1.7)+ 0.06);
r0 = pow(r0, 2.2);
#endif

#ifdef LOGARITHMIC
r0 = r0 * toneMapExposure;
float pixelLumi = dot(r0.xyz, _c12.xyz);
float toneMapCalc= log10(1 + pixelLumi) / log10(1 + r10);
r0 = toneMapCalc * pow(r0 / pixelLumi, Saturation);
#endif

r0.xyz = lerp(r0.xyz, 0.5 * (1 + sin((r0.xyz - 0.5)*3.1415926)), AddContrast);
r0=BloomAmountMix*r7 * r3.x + r0;


#ifdef BLACKBARS
//Vignette code from hd7


float rovigpwr = 0; //for a circular vignette
float2 sqvigpwr = float2( 1.5, 1.5 ); // for the top and bottom of the screen
float vsatstrength = 0; // color distortion
float vignettepow = 0; // increases the contrast and sharpness
float vstrengthatnight = 7.5;

 float2 inTex = _v0; 
float vhnd = 0.5;
 float4 voriginal = r0;
 float4 vcolor = voriginal;
 vcolor.xyz=1;
 inTex -= 0.5; // center
 inTex.y += 0.01; // offset from the center
 float vignette = 1.0 - dot( inTex, inTex );
 vcolor *= pow( vignette, vignettepow );

 float4 rvigtex = vcolor;
 rvigtex.xyz = pow( vcolor, 1 );
 rvigtex.xyz = lerp(float3(0.5, 0.5, 0.5), rvigtex.xyz, 2.0); // contrast
 rvigtex.xyz = lerp(float3(1,1,1),rvigtex.xyz,rovigpwr); // strength of the circular vinetty

//darken the top and bottom
 float4 vigtex = vcolor;
 vcolor.xyz = float3(1,1,1);
 float3 topv = min((inTex.y+0.5)*2,1.5) * 2; // top
 float3 botv = min(((0-inTex.y)+0.5)*2,1.5) * 2; // botton
 topv= lerp(float3(1,1,1), topv, sqvigpwr.x);
 botv= lerp(float3(1,1,1), botv, sqvigpwr.y);
 vigtex.xyz = (topv)*(botv);
 //vigtex.xyz = lerp(float3(1,1,1),vigtex.xyz,sqvigpwr); // strength of the top and bottom

 // mix the two types of vignettes
 vigtex.xyz*=rvigtex.xyz; 
vigtex.xyz = lerp(vigtex.xyz,float3(1,1,1),(1-vstrengthatnight)*(1-vhnd)); //for a dark screen
 vigtex.xyz = min(vigtex.xyz,1);
 vigtex.xyz = max(vigtex.xyz,0);
 float3 vtintensity = dot(r0.xyz, float3(0.2125, 0.7154, 0.0721));
 r0.xyz = lerp(vtintensity, r0.xyz, ((((1-(vigtex.xyz*2))+2)-1)*vsatstrength)+1 );
 //color.xyz+=0.02;
 r0.xyz *= (vigtex.xyz);
#endif

//#define VIGNETTE
#ifdef VIGNETTE
float rovigpwr = 0.75; //for a circular vignette
float2 sqvigpwr = float2( 0.5, 0.5 ); // for the top and bottom of the screen
float vsatstrength = 1; // color distortion
float vignettepow = 1; // increases the contrast and sharpness
float vstrengthatnight = 10.25;
 float2 inTex = _v0; 
 float vhnd = 0.5;
 float4 voriginal = r0;
 float4 vcolor = voriginal;
 vcolor.xyz=1;
 inTex -= 0.5; // center
 inTex.y += 0.01; // offset from the center
 float vignette = 1.0 - dot( inTex, inTex );
 vcolor *= pow( vignette, vignettepow );
 float4 rvigtex = vcolor;
 rvigtex.xyz = pow( vcolor, 1 );
 rvigtex.xyz = lerp(float3(0.5, 0.5, 0.5), rvigtex.xyz, 2.0); // contrast
 rvigtex.xyz = lerp(float3(1,1,1),rvigtex.xyz,rovigpwr); // strength of the circular vinetty
 float4 vigtex = vcolor;
 vcolor.xyz = float3(1,1,1);
 float3 topv = min((inTex.y+0.5)*2,1.5) * 2; // top
 float3 botv = min(((0-inTex.y)+0.5)*2,1.5) * 2; // botton
 topv= lerp(float3(1,1,1), topv, sqvigpwr.x);
 botv= lerp(float3(1,1,1), botv, sqvigpwr.y);
 vigtex.xyz = (topv)*(botv);
 vigtex.xyz*=rvigtex.xyz; 
vigtex.xyz = lerp(vigtex.xyz,float3(1,1,1),(1-vstrengthatnight)*(1-vhnd)); //for a dark screen
 vigtex.xyz = min(vigtex.xyz,1);
 vigtex.xyz = max(vigtex.xyz,0);
 float3 vtintensity = dot(r0.xyz, float3(0.2125, 0.7154, 0.0721));
 r0.xyz = lerp(vtintensity, r0.xyz, ((((1-(vigtex.xyz*2))+2)-1)*vsatstrength)+1 );
 r0.xyz *= (vigtex.xyz);
#endif


focus = length(center.xy)*1.41421;
focus = pow(focus, 4);

r0.xyz -= focus * Vignetting;

_oC0.xyz=r0.xyz;


//_oC0=0.077*tex2D(s15, _v0.xy);//s2



//_oC0.xyz=1.0;






	//_oC0.w=1.0;
	return _oC0;
}


//mine temporary post process
technique Shader_C215BE6E
{
    pass p0 
    {
		PixelShader  = compile ps_3_0 PS_C215BE6E();
	}
}




//original shader of post processing
technique Shader_ORIGINALPOSTPROCESS
{
    pass p0 
    {

	PixelShader= 
	asm
	{
//
// Generated by Microsoft (R) HLSL Shader Compiler 9.23.949.2378
//
// Parameters:
//
//   sampler2D AdapLumSampler;
//   sampler2D BloomSampler;
//   float4 ColorCorrect;
//   float4 ColorShift;
//   float Exposure;
//   sampler2D GBufferTextureSampler2;
//   sampler2D GBufferTextureSampler3;
//   sampler2D HDRSampler;
//   sampler2D JitterSampler;
//   float PLAYER_MASK;
//   sampler2D StencilCopySampler;
//   float4 TexelSize;
//   float4 ToneMapParams;
//   float4 deSatContrastGamma;
//   float4 dofBlur;
//   float4 dofDist;
//   float4 dofProj;
//   float gDirectionalMotionBlurLength;
//   float4 globalScreenSize;
//   row_major float4x4 motionBlurMatrix;
//
//
// Registers:
//
//   Name                         Reg   Size
//   ---------------------------- ----- ----
//   globalScreenSize             c44      1
//   Exposure                     c66      1
//   motionBlurMatrix             c72      4
//   TexelSize                    c76      1
//   dofProj                      c77      1
//   dofDist                      c78      1
//   dofBlur                      c79      1
//   gDirectionalMotionBlurLength c80      1
//   ToneMapParams                c81      1
//   deSatContrastGamma           c82      1
//   ColorCorrect                 c83      1
//   ColorShift                   c84      1
//   PLAYER_MASK                  c85      1
//   GBufferTextureSampler2       s0       1
//   GBufferTextureSampler3       s1       1
//   HDRSampler                   s2       1
//   BloomSampler                 s3       1
//   AdapLumSampler               s4       1
//   JitterSampler                s5       1
//   StencilCopySampler           s6       1
//

    ps_3_0
    def c0, 0, 0.212500006, 0.715399981, 0.0720999986
    def c1, 0.25, 1, 256, 0
    def c2, 0, 2, 4, 8
    def c3, 58.1640015, 47.1300011, 0, 0
    def c4, -0.5, -1.5, 1.5, 0.5
    def c5, 2, -1, 0.125, 0
    def c6, 256, 2, 4, 8
def c180, 0.0, 0.0, 0.0, 100.5
def c181, 1.0, 0.0, 0.0, 20.01
def c183, 800.0, 600.0, 0.0, 100.5
    defi i0, 7, 0, 0, 0
    dcl_texcoord v0.xy
    dcl_2d s0
    dcl_2d s1
    dcl_2d s2
    dcl_2d s3
    dcl_2d s4
    dcl_2d s5
    dcl_2d s6
    texld r0, v0, s1
    add r0.y, -c77.x, c77.y
    rcp r0.y, r0.y
    mul r0.z, r0.y, c77.y
    mul r0.z, r0.z, -c77.x
    mad r0.x, c77.y, -r0.y, r0.x
    rcp r0.x, r0.x
    mul r0.y, r0.z, r0.x
    texld r1, v0, s2
    texld r2, v0, s3
    abs r0.w, c79.w
    mov r3, c4
    mad r4.xy, c76, r3, v0
    texld r4, r4, s2
    mad r5.xy, c76, r3.zxzw, v0
    texld r5, r5, s2
    mad r3.xz, c76.xyyw, r3.wyzw, v0.xyyw
    texld r6, r3.xzzw, s2
    mad r3.xy, c76, r3.ywzw, v0
    texld r7, r3, s2
    dp3 r1.w, r4, r4
    rcp r1.w, r1.w
    cmp r3.xyz, -r1.w, c0.x, r4
    dp3 r1.w, r5, r5
    rcp r1.w, r1.w
    cmp r4.xyz, -r1.w, c0.x, r5
    dp3 r1.w, r6, r6
    rcp r1.w, r1.w
    cmp r5.xyz, -r1.w, c0.x, r6
    dp3 r1.w, r7, r7
    rcp r1.w, r1.w
    cmp r6.xyz, -r1.w, c0.x, r7
    dp3 r1.w, r1, r1
    rcp r1.w, r1.w
    cmp r7.xyz, -r1.w, c0.x, r1
    mad r0.x, r0.z, r0.x, -c78.w
    mad r0.x, c78.y, -r3.w, r0.x
    max r1.w, r0.x, c0.x
    rcp r0.x, c78.z
    mul r0.x, r1.w, r0.x
    lrp r1.w, r0.x, c79.z, c79.y
    min r0.x, c79.z, r1.w
    dp3 r0.z, r7, c0.yzww
    dp3 r8.x, r3, c0.yzww
    dp3 r8.y, r4, c0.yzww
    dp3 r8.z, r5, c0.yzww
    dp3 r8.w, r6, c0.yzww
    dp4 r1.w, r8, c1.x
    add r8, r8, -r1.w
    dp4 r2.w, r8, r8
    add r0.z, r0.z, -r1.w
    mad r0.z, r0.z, r0.z, -r2.w
    mul r0.x, r0.x, r0.x
    cmp r0.x, r0.z, c1.y, r0.x
    texld r8, v0, s0
    mov r8.yz, c1
    mad r9, r8.w, -r8.z, c2
    cmp r9, r9, c1.y, c1.w
    mad r10, r8.w, -c6.x, c6.yzwx
    cmp r10, r10, -c1.y, -c1.w
    add r9, r9, r10
    mul r9, r9, c4.x
    dp4 r0.z, r9, c1.y
    add r0.z, r0.z, c4.w
    rcp r0.z, r0.z
    mul r8.xzw, r3.xyyz, r9.x
    mad r7.xyz, r7, c4.w, r8.xzww
    mad r7.xyz, r4, r9.y, r7
    mad r7.xyz, r5, r9.z, r7
    mad r7.xyz, r6, r9.w, r7
    mul r7.xyz, r0.z, r7
    add r0.z, -r0.x, c1.y
    mul r1.w, r0.x, c1.x
    mul r3.xyz, r3, r1.w
    mad r3.xyz, r7, r0.z, r3
    mad r3.xyz, r4, r1.w, r3
    mad r3.xyz, r5, r1.w, r3
    mad r3.xyz, r6, r1.w, r3
    mad r4.xyz, v0.yxyw, c5.x, c5.y
    mul r0.z, r4.y, c77.z
    mul r0.z, r0.y, r0.z
    mul r1.w, -r4.x, c77.w
    mul r1.w, r0.y, r1.w
    mul r5.xyz, r1.w, c73
    mad r5.xyz, r0.z, c72, r5
    mad r5.xyz, -r0.y, c74, r5
    add r5.xyz, r5, c75
    mul r0.y, -r5.z, c77.z
    rcp r0.y, r0.y
    mul r6.x, r5.x, r0.y
    mul r0.y, r5.z, c77.w
    rcp r0.y, r0.y
    mul r6.y, r5.y, r0.y
    add r0.yz, -r4, r6.xxyw
    mul r0.yz, r0, c80.x
    mul r4.xy, r0.yzzw, c5.z
    texld r5, v0, s6
    add r1.w, r5.x, -c85.x
    mul r4.zw, r3.xyxy, c2.w
    mad r4.zw, v0.xyxy, c3.xyxy, r4
    texld r5, r4.zwzw, s5
    add r2.w, r5.x, c4.x
    mad r4.zw, r4.xyxy, r2.w, v0.xyxy
    mov r5.xyz, r3
    mov r2.w, c1.y
    mov r3.w, c1.y

    rep i0
      mad r6.xy, r4, r3.w, r4.zwzw
      texld r7, r6, s6
      add r5.w, r7.x, -c85.x
      cmp r5.w, r5.w, c1.w, c1.y
      texld r6, r6, s2
      mad r5.xyz, r6, r5.w, r5
      add r2.w, r2.w, r5.w
      add r3.w, r3.w, c1.y
    endrep

    rcp r2.w, r2.w
    mul r0.yz, r0, c183.xxyw//c44.xxyw
    dp2add r0.y, r0.yzzw, r0.yzzw, c0.x
    rsq r0.y, r0.y
    rcp r0.y, r0.y
    mul r0.y, r0.y, c4.w
    add r0.x, r0.x, c1.y
    rcp r0.x, r0.x
    mul_sat r0.x, r0.y, r0.x
    mad r4.xyz, r5, r2.w, -r3
    mad r0.xyz, r0.x, r4, r3
    cmp r0.xyz, r1.w, r3, r0
    cmp r0.xyz, -r0.w, r0, r1

    texld r1, c0.x, s4
    rcp r0.w, r1.x
    mul r0.w, r0.w, c81.y
    rcp r1.x, r0.w
    mul r1.x, r1.x, c81.x
    mad r1.xyz, r2, c66.x, -r1.x
    max r2.xyz, r1, c0.x
    mul r1.xyz, r2, c81.z
    mul r1.xyz, r1, c1.x
    mad r0.xyz, r0, c66.x, r1
    mul r1.xyz, r0.w, r0
    dp3 r1.x, r1, c0.yzww
    mad r0.xyz, r0, r0.w, -r1.x
    mad r0.xyz, c82.x, r0, r1.x
    mul r0.w, r1.x, c84.w
    mul r1.yzw, r0.w, c84.xxyz
    mov_sat r2.x, r0.w
    mad r0.xyz, c84, -r0.w, r0
    mad r0.xyz, r2.x, r0, r1.yzww
    mul r0.xyz, r0, c83
    add r0.xyz, r0, r0
    mov_sat r1.x, r1.x
    add r0.w, -r8.y, c82.z
    pow r2.x, r1.x, r0.w
//mul r2.x, r2.x, c181.x
    mul oC0.xyz, r0, r2.x
    mov oC0.w, c1.y

//texld r1, v0, s2
//mul oC0.xyz, r1, c199.z
	};
    }
}

